/*
 * (C) Copyright 2000-2002
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * (C) Copyright 2001 Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Andreas Heppel <aheppel@sysgo.de>

 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <command.h>
#include <asm/io.h>
#include <asm/arch/mx53.h>
#include <environment.h>
#include <linux/stddef.h>
#include <malloc.h>

DECLARE_GLOBAL_DATA_PTR;

#ifdef CONFIG_AMIGAONEG3SE
	extern void enable_nvram(void);
	extern void disable_nvram(void);
#endif

//#undef DEBUG_ENV
#define DEBUG_ENV 1
#ifdef DEBUG_ENV
#define DEBUGF(fmt,args...) printf(fmt ,##args)
#else
#define DEBUGF(fmt,args...)
#endif

extern env_t *env_ptr;

unsigned int gProdId;
#if 0
uchar gLcdType_1050[30] = "set_display=run tsw1050_lcd\0";
uchar gLcdType_750[30] = "set_display=run tsw750_lcd\0";
uchar gLcdType_600[30] = "set_display=run tst600_lcd\0";
uchar gLcdType_550[30] = "set_display=run tsw550_lcd\0";
uchar gLcdType_300[30] = "set_display=run tsr300_lcd\0";
#endif
uchar gLcdType_1050[30] = "run tsw1050_lcd\0";
uchar gLcdType_750[30] = "run tsw750_lcd\0";
uchar gLcdType_M750[30] = "run tsm750_lcd\0";
uchar gLcdType_600[30] = "run tst600_lcd\0";
uchar gLcdType_900[30] = "run tst900_lcd\0";
uchar gLcdType_550[30] = "run tsw550_lcd\0";
uchar gLcdType_300[30] = "run tsr300_lcd\0";

extern void env_relocate_spec (void);
extern uchar env_get_char_spec(int);

static uchar env_get_char_init (int index);

/************************************************************************
 * Default settings to be used when no valid environment is found
 */
#define XMK_STR(x)	#x
#define MK_STR(x)	XMK_STR(x)


uchar default_environment[] = {
#ifdef	CONFIG_BOOTARGS
	"bootargs="	CONFIG_BOOTARGS			"\0"
#endif
#ifdef	CONFIG_BOOTCOMMAND
	"bootcmd="	CONFIG_BOOTCOMMAND		"\0"
#endif
#ifdef	CONFIG_RAMBOOTCOMMAND
	"ramboot="	CONFIG_RAMBOOTCOMMAND		"\0"
#endif
#ifdef	CONFIG_NFSBOOTCOMMAND
	"nfsboot="	CONFIG_NFSBOOTCOMMAND		"\0"
#endif
#if defined(CONFIG_BOOTDELAY) && (CONFIG_BOOTDELAY >= 0)
	"bootdelay="	MK_STR(CONFIG_BOOTDELAY)	"\0"
#endif
#if defined(CONFIG_BAUDRATE) && (CONFIG_BAUDRATE >= 0)
	"baudrate="	MK_STR(CONFIG_BAUDRATE)		"\0"
#endif
#ifdef	CONFIG_LOADS_ECHO
	"loads_echo="	MK_STR(CONFIG_LOADS_ECHO)	"\0"
#endif
#ifdef	CONFIG_ETHADDR
	"ethaddr="	MK_STR(CONFIG_ETHADDR)		"\0"
#endif
#ifdef	CONFIG_ETH1ADDR
	"eth1addr="	MK_STR(CONFIG_ETH1ADDR)		"\0"
#endif
#ifdef	CONFIG_ETH2ADDR
	"eth2addr="	MK_STR(CONFIG_ETH2ADDR)		"\0"
#endif
#ifdef	CONFIG_ETH3ADDR
	"eth3addr="	MK_STR(CONFIG_ETH3ADDR)		"\0"
#endif
#ifdef	CONFIG_ETH4ADDR
	"eth4addr="	MK_STR(CONFIG_ETH4ADDR)		"\0"
#endif
#ifdef	CONFIG_ETH5ADDR
	"eth5addr="	MK_STR(CONFIG_ETH5ADDR)		"\0"
#endif
#ifdef	CONFIG_IPADDR
	"ipaddr="	MK_STR(CONFIG_IPADDR)		"\0"
#endif
#ifdef	CONFIG_SERVERIP
	"serverip="	MK_STR(CONFIG_SERVERIP)		"\0"
#endif
#ifdef	CONFIG_SYS_AUTOLOAD
	"autoload="	CONFIG_SYS_AUTOLOAD			"\0"
#endif
#ifdef	CONFIG_PREBOOT
	"preboot="	CONFIG_PREBOOT			"\0"
#endif
#ifdef	CONFIG_ROOTPATH
	"rootpath="	MK_STR(CONFIG_ROOTPATH)		"\0"
#endif
#ifdef	CONFIG_GATEWAYIP
	"gatewayip="	MK_STR(CONFIG_GATEWAYIP)	"\0"
#endif
#ifdef	CONFIG_NETMASK
	"netmask="	MK_STR(CONFIG_NETMASK)		"\0"
#endif
#ifdef	CONFIG_HOSTNAME
	"hostname="	MK_STR(CONFIG_HOSTNAME)		"\0"
#endif
#ifdef	CONFIG_BOOTFILE
	"bootfile="	MK_STR(CONFIG_BOOTFILE)		"\0"
#endif
#ifdef	CONFIG_LOADADDR
	"loadaddr="	MK_STR(CONFIG_LOADADDR)		"\0"
#endif
#ifdef  CONFIG_CLOCKS_IN_MHZ
	"clocks_in_mhz=1\0"
#endif
#if defined(CONFIG_PCI_BOOTDELAY) && (CONFIG_PCI_BOOTDELAY > 0)
	"pcidelay="	MK_STR(CONFIG_PCI_BOOTDELAY)	"\0"
#endif
#ifdef  CONFIG_EXTRA_ENV_SETTINGS
	CONFIG_EXTRA_ENV_SETTINGS
#endif
	"\0"
};

#if defined(CONFIG_ENV_IS_IN_NAND)		/* Environment is in Nand Flash */ \
	|| defined(CONFIG_ENV_IS_IN_SPI_FLASH) \
	|| defined(CONFIG_ENV_IS_IN_MMC)
int default_environment_size = sizeof(default_environment)+30;
#endif

void env_crc_update (void)
{
	env_ptr->crc = crc32(0, env_ptr->data, ENV_SIZE);
}

static uchar env_get_char_init (int index)
{
	uchar c;

	/* if crc was bad, use the default environment */
	if (gd->env_valid)
	{
		c = env_get_char_spec(index);
	} else {
		c = default_environment[index];
	}

	return (c);
}

#ifdef CONFIG_AMIGAONEG3SE
uchar env_get_char_memory (int index)
{
	uchar retval;
	enable_nvram();
	if (gd->env_valid) {
		retval = ( *((uchar *)(gd->env_addr + index)) );
	} else {
		retval = ( default_environment[index] );
	}
	disable_nvram();
	return retval;
}
#else
uchar env_get_char_memory (int index)
{
	if (gd->env_valid) {
		return ( *((uchar *)(gd->env_addr + index)) );
	} else {
		return ( default_environment[index] );
	}
}
#endif

uchar env_get_char (int index)
{
	uchar c;

	/* if relocated to RAM */
	if (gd->flags & GD_FLG_RELOC)
		c = env_get_char_memory(index);
	else
		c = env_get_char_init(index);

	return (c);
}

uchar *env_get_addr (int index)
{
	if (gd->env_valid) {
		return ( ((uchar *)(gd->env_addr + index)) );
	} else {
		return (&default_environment[index]);
	}
}

#define MAX_REBOOTS	5
#define MAX_GOLDEN_REBOOTS	3
void
checkBootRetry ( void )
{
	int retryValue = 0;
	int goldenRetryValue = 0;
	uchar *testPrnt = NULL;
	char retryStr[20];

	testPrnt=getenv("boot_retry");
	if ( testPrnt != NULL )
	{
		retryValue=testPrnt[0] - 0x30;
		if ( ( retryValue < 0 ) ||( retryValue > 9 ) )
		{
			retryValue = 0;
		}
		//DEBUGF ("Checking reboot value %s == %d\n", testPrnt, retryValue );
	}
	else
	{
		DEBUGF ("Defaulting reboot value boot_retry == %d\n", retryValue );
	}

	retryValue++;

	testPrnt=getenv("golden_boot_retry");
	if ( testPrnt != NULL )
	{
		goldenRetryValue=testPrnt[0] - 0x30;
		if ( ( goldenRetryValue < 0 ) ||( goldenRetryValue > 9 ) )
		{
			goldenRetryValue = 0;
		}
		//DEBUGF ("Checking golden reboot value %s == %d\n", testPrnt, goldenRetryValue );
	}
	else
	{
		DEBUGF ("Defaulting golden reboot value boot_retry == %d\n", goldenRetryValue );
	}
	goldenRetryValue++;


	if ( retryValue > MAX_REBOOTS )
	{
		// Boot the golden image
		if ( goldenRetryValue > MAX_GOLDEN_REBOOTS )
		{
			setenv ( "bootcmd_SD2", "mmc read 0 ${loadaddr} 0x800 0x2000;mmc read 0 ${rd_loadaddr} 0x3000 0x300;bootm ${loadaddr} ${rd_loadaddr}" );
			retryValue = MAX_REBOOTS - 1; // allow us to go to default at least once
			goldenRetryValue = 0;
		}
		else
		{
			setenv ( "bootcmd_SD2", "mmc read 0 ${loadaddr} 0x3800 0x2000;mmc read 0 ${rd_loadaddr} 0x6000 0x300;bootm ${loadaddr} ${rd_loadaddr}" );
		}
	}
	else
	{
		setenv ( "bootcmd_SD2", "mmc read 0 ${loadaddr} 0x800 0x2000;mmc read 0 ${rd_loadaddr} 0x3000 0x300;bootm ${loadaddr} ${rd_loadaddr}" );
		goldenRetryValue = 0;
	}

	if ( retryValue <= (MAX_REBOOTS + 1) )
	{
	  sprintf ( retryStr, "%d", retryValue );
	  setenv ( "boot_retry", retryStr );
	}

  sprintf ( retryStr, "%d", goldenRetryValue );
  setenv ( "golden_boot_retry", retryStr );

	testPrnt=getenv("boot_retry");
	//DEBUGF ("Reboot value set to %s\n", testPrnt );

	testPrnt=getenv("golden_boot_retry");
	//DEBUGF ("Golden Reboot value set to %s\n", testPrnt );
}

// RJK: get Crestron ID to decide which LCD configuration to load
int AddCustomLCD(void)
{
	int ii;
	uchar *tempType;
	uchar *testPrnt;
	int xtraSize;

	testPrnt=getenv("set_display");
	DEBUGF ("set_display= %s\n", testPrnt);

	switch (gProdId)
	{
		case TSW1050:
		{
			tempType=gLcdType_1050;
			break;
		}
		case TSM750:
		{
			tempType=gLcdType_M750;
			break;
		}
		case TSW750:
		{
			tempType=gLcdType_750;
			break;
		}
		case TSW550:
		{
			tempType=gLcdType_550;
			break;
		}
		case TST900:
		{
			tempType=gLcdType_900;
			break;
		}
		case TSR300:
		{
			tempType=gLcdType_300;
			break;
		}
		case TST600:
		default:
		{
			tempType=gLcdType_600;
			break;
		}
	}
	setenv("set_display", tempType);

	return 0;
}

void set_default_env(void)
{

	if (sizeof(default_environment) > ENV_SIZE) {
		puts ("*** Error - default environment is too large\n\n");
		return;
	}
	DEBUGF ("Resetting to default ENV\n");

	memset(env_ptr, 0, sizeof(env_t));
		
	memcpy(env_ptr->data, default_environment,
	       sizeof(default_environment));
#ifdef CONFIG_SYS_REDUNDAND_ENVIRONMENT
	env_ptr->flags = 0xFF;
#endif
	// No need to add it here, because if you've never saved the env it means you never booted
	// Or got proper config from factory (MAC, TSID etc), so it's not worth trying to recover.
	// checkBootRetry();
	env_crc_update ();
	gd->env_valid = 1;
	saveenv();
}

void env_relocate (void)
{
	uchar *testPrnt;
	DEBUGF ("%s[%d] offset = 0x%lx\n", __FUNCTION__,__LINE__,
		gd->reloc_off);

#ifdef CONFIG_AMIGAONEG3SE
	enable_nvram();
#endif

#ifdef ENV_IS_EMBEDDED
	/*
	 * The environment buffer is embedded with the text segment,
	 * just relocate the environment pointer
	 */
	env_ptr = (env_t *)((ulong)env_ptr + gd->reloc_off);
	DEBUGF ("%s[%d] embedded ENV at %p\n", __FUNCTION__,__LINE__,env_ptr);
#else
	/*
	 * We must allocate a buffer for the environment
	 */
	env_ptr = (env_t *)malloc (CONFIG_ENV_SIZE);
	DEBUGF ("%s[%d] malloced ENV at %p\n", __FUNCTION__,__LINE__,env_ptr);
#endif

	if (gd->env_valid == 0) {
#if defined(CONFIG_GTH)	|| defined(CONFIG_ENV_IS_NOWHERE)	/* Environment not changable */
		puts ("Using default environment\n\n");
#else
		puts ("*** Warning - bad CRC, using default environment\n\n");
		show_boot_progress (-60);
#endif
		set_default_env();
	}
	else {
		env_relocate_spec ();
	}
	gd->env_addr = (ulong)&(env_ptr->data);

#ifdef CONFIG_AMIGAONEG3SE
	disable_nvram();
#endif


//	testPrnt=getenv("set_display");
//	DEBUGF ("Final set_display to: %s\n", testPrnt);
}

#ifdef CONFIG_AUTO_COMPLETE
int env_complete(char *var, int maxv, char *cmdv[], int bufsz, char *buf)
{
	int i, nxt, len, vallen, found;
	const char *lval, *rval;


	found = 0;
	cmdv[0] = NULL;

	len = strlen(var);
	/* now iterate over the variables and select those that match */
	for (i=0; env_get_char(i) != '\0'; i=nxt+1) {

		for (nxt=i; env_get_char(nxt) != '\0'; ++nxt)
			;

		lval = (char *)env_get_addr(i);
		rval = strchr(lval, '=');
		if (rval != NULL) {
			vallen = rval - lval;
			rval++;
		} else
			vallen = strlen(lval);

		if (len > 0 && (vallen < len || memcmp(lval, var, len) != 0))
			continue;

		if (found >= maxv - 2 || bufsz < vallen + 1) {
			cmdv[found++] = "...";
			break;
		}
		cmdv[found++] = buf;
		memcpy(buf, lval, vallen); buf += vallen; bufsz -= vallen;
		*buf++ = '\0'; bufsz--;
	}

	cmdv[found] = NULL;
	return found;
}
#endif
